/*
								+--------------------------------+
								|                                |
								|   ***  Call stack guard  ***   |
								|                                |
								|  Copyright  -tHE SWINe- 2005  |
								|                                |
								|         CallStack.cpp          |
								|                                |
								+--------------------------------+
*/

/*
 *	passed code revision at 2006-05-16
 *
 *	added the p_s_Format() function, fixed some logging errors
 *	added couple of _ASSERTE-s to CCallStackGuard::file_printf
 *
 *	passed code revision at 2007-02-05
 *
 *	fixed pointer / iterator type mismatch in CCallStackGuard::~CCallStackGuard()
 *	removed handcrafted loops over std::vector, using std::for_each instead
 *	fixed 'the' typo in code history
 *
 *	2007-03-06
 *
 *	removed __declspec(dllexport)
 *	fixed error arround separator concatenating in call stack dump
 *
 *	2007-10-29
 *
 *	enhanced linux compatibility
 *
 *	2007-11-12
 *
 *	reformat (added line breaks where lines were longer than 100 characters)
 *
 *	2008-02-06
 *
 *	slightly improved assertion for console apps (needs no memory allocation)
 *	changed message formatting a bit
 *
 *	2008-04-20
 *
 *	added a couple of #ifdefs which disable compilation of CCallStackGuard
 *	in cases it's not needed
 *
 *	2008-08-08
 *
 *	added #ifdef for windows 64
 *
 *	2009-05-23
 *
 *	added check for NewFix.h inclusion (todo - maybe remove it, it might be rather annoying)
 *
 *	2009-06-01
 *
 *	rewritten call-stack compile logic, added _USE_STACK_GUARD_IN_RELEASE macro
 *
 *	renamed CCallStackGuard to CCallStackMonitor
 *
 *	removed p_s_Format() functions, use stl_ut::Format() from StlUtils.h instead
 *
 *	2009-10-20
 *
 *	fixed some warnings when compiling under VC 2005, implemented "Security
 *	Enhancements in the CRT " for VC 2008. compare against MyProjects_2009-10-19_
 *
 *	checking NewFix presence under MSVC 6.0 only
 *
 */

#include "NewFix.h"

#ifndef __ULAME_SUPPRESS_NEW_FIX_PRESENCE_TEST
#ifndef __ULAME_SUPPRESS_NEW_FIX
extern void Please_Include_UberLame_src_NewFix_cpp();
static class CTest_NewFix_Presence {
public:
	CTest_NewFix_Presence()
	{
		Please_Include_UberLame_src_NewFix_cpp();
		// this is used only to test presence of NewFix.cpp in the project
	}
} __test_new_fix_presence;
#endif //__ULAME_SUPPRESS_NEW_FIX
#endif //__ULAME_SUPPRESS_NEW_FIX_PRESENCE_TEST
// callstack.h is usualy (or should be) included.in any UberLame project
// make sure NewFix.cpp is included as well

#if defined(_WIN32) || defined (_WIN64)
#include <windows.h>
#endif
#include <stdarg.h>
#include <stdio.h>
#include <vector>
#include <algorithm>
#include "CallStack.h"
#include "StlUtils.h"

#if defined(_MSC_VER) && !defined(__MWERKS__) && !defined(for)
#define for if(0) {} else for
#endif

/*
 *								=== CCallStackMonitor ===
 */

#if __HAVE_FUNCGUARD__

std::vector<const char*> CCallStackMonitor::m_call_stack;

/*
 *	CCallStackMonitor::CCallStackMonitor(const char *p_s_function_name)
 *		- default constructor, insert pointer to parent function name into the list
 */
CCallStackMonitor::CCallStackMonitor(const char *p_s_function_name)
{
	if(stl_ut::Reserve_1More(m_call_stack))
		m_call_stack.push_back(p_s_function_name);
	else
		Abort();
}

/*
 *	CCallStackMonitor::~CCallStackMonitor()
 *		- default destructor, remove last pointer
 */
CCallStackMonitor::~CCallStackMonitor()
{
	m_call_stack.erase(m_call_stack.end() - 1);
#ifdef _DEBUG
	if(m_call_stack.empty()) {
		std::vector<const char*> empty_vec;
		m_call_stack.swap(empty_vec);
	}
	// attempt to completely deallocate vector not to hinder memory leak debugging
#endif //_DEBUG
}

/*
 *	static const std::vector<const char*> &CCallStackMonitor::Get()
 *		- returns current state of call stack (vector, containing list of function names)
 */
const std::vector<const char*> &CCallStackMonitor::Get()
{
	return m_call_stack;
}

/*
 *	static bool CCallStackMonitor::Get(std::string &r_s_stack, const char *p_s_separator)
 *		- copies string, containing function names, separated by p_s_separator to r_s_stack
 *		- returns true on success, false on failure (not enough memory for the string)
 *		- note any of p_s_separator, p_s_pro or p_s_epi can be null
 */
bool CCallStackMonitor::Get(std::string &r_s_stack, const char *p_s_separator)
{
	r_s_stack.erase();
	// erase

	for(size_t i = 0, n = m_call_stack.size(); i < n; ++ i) {
		if(!r_s_stack.empty() && p_s_separator && !stl_ut::AppendCStr(r_s_stack, p_s_separator))
			return false;
		// appends separator

		if(!stl_ut::AppendCStr(r_s_stack, m_call_stack[i]) ||
		   !stl_ut::AppendCStr(r_s_stack, "()"))
			return false;
		// appends function name
	}
	// concatenates function names

	return true;
}

#endif //__HAVE_FUNCGUARD__

#if __HAVE_ASSERTE__ || __HAVE_FUNCGUARD__

/*
 *	static void CCallStackMonitor::Abort()
 *		- stops program execution
 *		- note this uses interrupt 3 "user breakpoint" in MSVC, or exit(-1) elsewhere
 */
void CCallStackMonitor::Abort()
{
#if defined(_MSC_VER) && !defined(__MWERKS__)
#if defined(__x86_64__) || defined(__x64__)
	exit(-1); // __asm is not supported in msvc/x64
#else
	__asm {
		int 3
	}
#endif
	// MSVC "user breakpoint"
#endif

	abort(); // CRT function
	exit(-1);
	// universal sollution
}

#endif //__HAVE_ASSERTE__ || __HAVE_FUNCGUARD__

#if __HAVE_ASSERTE__
#if (defined(_WIN32) || defined (_WIN64)) && !defined(_CONSOLE)

/*
 *	static void CCallStackMonitor::AssertHandler(const char *p_s_expr, int n_line, const char *p_s_file)
 *		- function, called when assertion failed
 *		- p_s_expr is expression that failed, n_line is line in source code expression lies on
 *		  and p_s_file is filename of source code
 *		- displays message box with description what and where happened and calls Abort()
 */
void CCallStackMonitor::AssertHandler(const char *p_s_expr, int n_line, const char *p_s_file)
{
#if __HAVE_FUNCGUARD__
	std::string s_message, s_call_stack;
	if(stl_ut::Format(s_message, "expression: '%s'\nfile: '%s'\nline: %d\n\ncall stack:\n",
	   p_s_expr, p_s_file, n_line) && Get(s_call_stack, " -> ") &&
	   stl_ut::Append(s_message, s_call_stack))
		MessageBoxA(0, s_message.c_str(), "Assertion failed", MB_OK | MB_ICONERROR);
	else
		MessageBoxA(0, "<Not enough memory>", "Assertion failed", MB_OK | MB_ICONERROR);
#else //__HAVE_FUNCGUARD__
	std::string s_message;
	if(stl_ut::Format(s_message, "expression: '%s'\nfile: '%s'\nline: %d",
	   p_s_expr, p_s_file, n_line))
		MessageBoxA(0, s_message.c_str(), "Assertion failed", MB_OK | MB_ICONERROR);
	else
		MessageBoxA(0, "<Not enough memory>", "Assertion failed", MB_OK | MB_ICONERROR);
#endif //__HAVE_FUNCGUARD__
	// formats and displays the message

	Abort();
	// abort
}

#else // _WIN32, _WIN64

/*
 *	static void CCallStackMonitor::AssertHandler(const char *p_s_expr, int n_line, const char *p_s_file)
 *		- function, called when assertion failed
 *		- p_s_expr is expression that failed, n_line is line in source code expression lies on
 *		  and p_s_file is filename of source code
 *		- prints message into stderr, describing what and where happened and calls Abort()
 */
void CCallStackMonitor::AssertHandler(const char *p_s_expr, int n_line, const char *p_s_file)
{
	fprintf(stderr, "=== Assertion failed ===\n"
		"expression: '%s'\nfile: '%s'\nline: %d\n",
		p_s_expr, p_s_file, n_line);
	// prints message header

#if __HAVE_FUNCGUARD__
	fprintf(stderr, "call stack: ");
	for(size_t i = 0, n = m_call_stack.size(); i < n; ++ i)
		fprintf(stderr, (i)? " -> %s" : "%s", m_call_stack[i]);
	fprintf(stderr, "\n");
	// prints call stack contents
#endif //__HAVE_FUNCGUARD__

	Abort();
	// abort
}

#endif // _WIN32, _WIN64
#endif //__HAVE_ASSERTE__

/*
 *								=== ~CCallStackMonitor ===
 */
