/*
								+----------------------------------+
								|                                  |
								| ***   Mersene twister rand   *** |
								|                                  |
				http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/MT2002/CODES/mt19937ar.c
								|                                  |
								|            Mersene.cpp           |
								|                                  |
								+----------------------------------+
*/

/*
 *	2007-11-14
 *
 *	enhanced linux compatibility by adding unix integer types
 *
 *	2008-03-04
 *
 *	now using Integer.h header
 *
 *	2009-05-04
 *
 *	fixed mixed windows / linux line endings
 *
 */

#include "NewFix.h"

#include "CallStack.h"
#include <string.h>
#include "Mersene.h"

#if defined(_MSC_VER) && !defined(__MWERKS__) && !defined(for)
#define for if(0) {} else for
#endif

CMerseneTwister::CMerseneTwister()
{
	m_n_init_index = N + 1;
}

/* initializes m_n_state[N] with a seed */
void CMerseneTwister::init_genrand(unsigned long s)
{
	m_n_state[0]= s & 0xffffffffUL;
	for (m_n_init_index=1; m_n_init_index<N; m_n_init_index++) {
		m_n_state[m_n_init_index] = 
		(1812433253UL * (m_n_state[m_n_init_index-1] ^ (m_n_state[m_n_init_index-1] >> 30)) + m_n_init_index); 
		/* See Knuth TAOCP Vol2. 3rd Ed. P.106 for multiplier. */
		/* In the previous versions, MSBs of the seed affect   */
		/* only MSBs of the array m_n_state[].                        */
		/* 2002/01/09 modified by Makoto Matsumoto             */
		m_n_state[m_n_init_index] &= 0xffffffffUL;
		/* for >32 bit machines */
	}
}

/* initialize by an array with array-length */
/* init_key is the array for initializing keys */
/* key_length is its length */
/* slight change for C++, 2004/2/26 */
void CMerseneTwister::init_by_array(unsigned long *init_key, int key_length)
{
	int i, j, k;
	init_genrand(19650218UL);
	i=1; j=0;
	k = (N>key_length ? N : key_length);
	for (; k; k--) {
		m_n_state[i] = (m_n_state[i] ^ ((m_n_state[i-1] ^ (m_n_state[i-1] >> 30)) * 1664525UL))
		  + init_key[j] + j; /* non linear */
		m_n_state[i] &= 0xffffffffUL; /* for WORDSIZE > 32 machines */
		i++; j++;
		if (i>=N) { m_n_state[0] = m_n_state[N-1]; i=1; }
		if (j>=key_length) j=0;
	}
	for (k=N-1; k; k--) {
		m_n_state[i] = (m_n_state[i] ^ ((m_n_state[i-1] ^ (m_n_state[i-1] >> 30)) * 1566083941UL))
		  - i; /* non linear */
		m_n_state[i] &= 0xffffffffUL; /* for WORDSIZE > 32 machines */
		i++;
		if (i>=N) { m_n_state[0] = m_n_state[N-1]; i=1; }
	}

	m_n_state[0] = 0x80000000UL; /* MSB is 1; assuring non-zero initial array */ 
}

/* generates a random number on [0,0xffffffff]-interval */
unsigned long CMerseneTwister::genrand_int32() const
{
	unsigned long y;
	static unsigned long mag01[2]={0x0UL, MATRIX_A};
	/* mag01[x] = x * MATRIX_A  for x=0,1 */

	if (m_n_init_index >= N) { /* generate N words at one time */
		int kk;

		if (m_n_init_index == N+1)   /* if init_genrand() has not been called, */
			((CMerseneTwister*)this)->init_genrand(5489UL); /* a default initial seed is used */

		for (kk=0;kk<N-M;kk++) {
			y = (m_n_state[kk]&UPPER_MASK)|(m_n_state[kk+1]&LOWER_MASK);
			m_n_state[kk] = m_n_state[kk+M] ^ (y >> 1) ^ mag01[y & 0x1UL];
		}
		for (;kk<N-1;kk++) {
			y = (m_n_state[kk]&UPPER_MASK)|(m_n_state[kk+1]&LOWER_MASK);
			m_n_state[kk] = m_n_state[kk+(M-N)] ^ (y >> 1) ^ mag01[y & 0x1UL];
		}
		y = (m_n_state[N-1]&UPPER_MASK)|(m_n_state[0]&LOWER_MASK);
		m_n_state[N-1] = m_n_state[M-1] ^ (y >> 1) ^ mag01[y & 0x1UL];

		m_n_init_index = 0;
	}

	y = m_n_state[m_n_init_index++];

	/* Tempering */
	y ^= (y >> 11);
	y ^= (y << 7) & 0x9d2c5680UL;
	y ^= (y << 15) & 0xefc60000UL;
	y ^= (y >> 18);

	return y;
}

/* generates a random number on [0,0x7fffffff]-interval */
long CMerseneTwister::genrand_int31() const
{
	return (long)(genrand_int32()>>1);
}

/* generates a random number on [0,1]-real-interval */
double CMerseneTwister::genrand_real1() const
{
	return genrand_int32()*(1.0/4294967295.0); 
	/* divided by 2^32-1 */ 
}

/* generates a random number on [0,1)-real-interval */
double CMerseneTwister::genrand_real2() const
{
	return genrand_int32()*(1.0/4294967296.0); 
	/* divided by 2^32 */
}

/* generates a random number on (0,1)-real-interval */
double CMerseneTwister::genrand_real3() const
{
	return (((double)genrand_int32()) + 0.5)*(1.0/4294967296.0); 
	/* divided by 2^32 */
}

/* generates a random number on [0,1) with 53-bit resolution*/
double CMerseneTwister::genrand_res53() const
{ 
	unsigned long a=genrand_int32()>>5, b=genrand_int32()>>6; 
	return(a*67108864.0+b)*(1.0/9007199254740992.0); 
}

/*
 *		~CMerseneTwister
 */
