/*
								+----------------------------------+
								|                                  |
								|     ***  STL utilities  ***      |
								|                                  |
								|   Copyright  -tHE SWINe- 2008   |
								|                                  |
								|           StlUtils.cpp           |
								|                                  |
								+----------------------------------+
*/

/*
 *
 *	2008-12-22
 *
 *	added typename keyword in Reserve_NMore() so it now compiles with g++
 *
 *	2009-01-13
 *
 *	added Format() function and StlUtils.cpp to keep it's body (it's not template)
 *
 *	2009-03-24
 *
 *	added Assign and Append, accepting std::string as second argument,
 *	should allow assigning and appending strings with different character
 *	types as well (no conversion or error handling though).
 *
 *	(there was just const char* before; it was possible to use these versions
 *	to append std::string to std::string using c_str() function, but it
 *	would expectably yield worse performance)
 *
 *	2009-05-04
 *
 *	stl_ut::Swap() was removed in favor of std::swap
 *
 *	added __STL_UTILS_ENABLE_EXCEPTIONS macro, controlling between exception-
 *	based and null-pointer based errors on operator new()
 *
 *	written documentation comments
 *
 *	2009-10-11
 *
 *	added Resize_To_N(), Resize_Add_1More() and Resize_Add_NMore() functions
 *	to help avoiding unhandled std::bad_alloc in container::resize()
 *
 *	added AssignWCStr(), AppendWCStr() and FormatW() to support wide character
 *	strings, can disable them by defining __STL_UTILS_NO_WIDE_STRINGS macro
 *
 *	added __STL_UT_CATCH_BAD_ALLOC macro, containing catch(std::bad_alloc&)
 *	(in case __STL_UTILS_ENABLE_EXCEPTIONS is not defined)
 *
 *	2009-10-20
 *
 *	fixed some warnings when compiling under VC 2005, implemented "Security
 *	Enhancements in the CRT " for VC 2008. compare against MyProjects_2009-10-19_
 *
 */

#include "NewFix.h"

#include "CallStack.h"
#if defined(_WIN32) || defined (_WIN64)
#include <windows.h>
#endif
#include <stdarg.h>
#include <stdio.h>
#include <vector>
#include <algorithm>
#include "StlUtils.h"

#if defined(_MSC_VER) && !defined(__MWERKS__) && !defined(for)
#define for if(0) {} else for
#endif

/*
 *								=== STL Utilities ===
 */

namespace stl_ut {

/*
 *	bool stl_ut::Format(std::string &r_s_result, const char *p_s_fmt, ...)
 *		- equivalent of standard "c" library sprintf function,
 *		  working with std::string output
 *		- returns true on success, false on failure (not enough memory)
 *		- note this is safe against output buffer overrun, but is
 *		  still susceptible to ill-formated format string (p_s_fmt)
 *		  and bad arguments (not enough of them / not corresponding
 *		  to tags in the format string). but as the first one being run-time
 *		  error and the latter one compile-time error, this brings
 *		  enought improvement.
 */
bool Format(std::string &r_s_result, const char *p_s_fmt, ...)
{
	va_list ap;

	size_t n_size = strlen(p_s_fmt) + 1;
	if(!Resize_To_N(r_s_result, n_size))
		return false;
	// alloc str as long as formatting str (should be enough in some cases)

	for(;;) {
		va_start(ap, p_s_fmt);
#if defined(_MSC_VER) && !defined(__MWERKS__) // msvc
#if _MSC_VER >= 1400
		int n = _vsnprintf_s(&r_s_result[0], n_size, _TRUNCATE, p_s_fmt, ap);
#else //_MSC_VER >= 1400
		int n = _vsnprintf(&r_s_result[0], n_size - 1, p_s_fmt, ap);
#endif //_MSC_VER >= 1400
		// maximum characters to write, not the size of buffer
#else
		int n = vsnprintf(&r_s_result[0], n_size, p_s_fmt, ap);
#endif
		va_end(ap);
		// try to sprintf

		if(n >= 0 && unsigned(n) < n_size) {
#if defined(_MSC_VER) && !defined(__MWERKS__) // msvc
			Resize_To_N(r_s_result, n);
#else
			Resize_To_N(r_s_result, strlen(r_s_result.data())); // doesn't need c_str(), terminating zero is already there
#endif
			_ASSERTE(r_s_result.length() == strlen(r_s_result.data()));
			return true;
		}
		// see if we made it

		if(n >= 0) // glibc 2.1
			n_size = n + 1; // precisely what is needed
		else // glibc 2.0, msvc
			n_size *= 2;

		if(!Resize_To_N(r_s_result, n_size))
			return false;
		// realloc to try again
	}
}

bool ReadLine(std::string &r_s_line, FILE *p_fr)
{
	r_s_line.erase();
	for(int c = fgetc(p_fr); c != '\n' && c != EOF; c = fgetc(p_fr)) {
		if(ferror(p_fr) || !stl_ut::Resize_Add_1More(r_s_line, c))
			return false;
	}
	// read line

	return !ferror(p_fr);
}

#ifndef __STL_UTILS_NO_WIDE_STRINGS

/*
 *	bool stl_ut::FormatW(std::basic_string<wchar_t> &r_s_result, const wchar_t *p_s_fmt, ...)
 *		- unicode equivalent of standard "c" library sprintf function,
 *		  working with std::string output
 *		- returns true on success, false on failure (not enough memory)
 *		- note this is safe against output buffer overrun, but is
 *		  still susceptible to ill-formated format string (p_s_fmt)
 *		  and bad arguments (not enough of them / not corresponding
 *		  to tags in the format string). but as the first one being run-time
 *		  error and the latter one compile-time error, this brings
 *		  enought improvement.
 */
bool FormatW(std::basic_string<wchar_t> &r_s_result, const wchar_t *p_s_fmt, ...)
{
	va_list ap;

	size_t n_size = wcslen(p_s_fmt) + 1;
	if(!Resize_To_N(r_s_result, n_size))
		return false;
	// alloc str as long as formatting str (should be enough in some cases)

	for(;;) {
		va_start(ap, p_s_fmt);
#if defined(_MSC_VER) && !defined(__MWERKS__) // msvc
#if _MSC_VER >= 1400
		int n = _vsnwprintf_s(&r_s_result[0], n_size, _TRUNCATE, p_s_fmt, ap);
#else //_MSC_VER >= 1400
		int n = _vsnwprintf(&r_s_result[0], n_size - 1, p_s_fmt, ap);
#endif //_MSC_VER >= 1400
		// maximum characters to write, not the size of buffer
#else
		int n = vsnwprintf(&r_s_result[0], n_size, p_s_fmt, ap);
#endif
		va_end(ap);
		// try to sprintf

		if(n >= 0 && unsigned(n) < n_size) {
#if defined(_MSC_VER) && !defined(__MWERKS__) // msvc
			Resize_To_N(r_s_result, n);
#else
			Resize_To_N(r_s_result, wcslen(r_s_result.data())); // doesn't need c_str(), terminating zero is already there
#endif
			_ASSERTE(r_s_result.length() == wcslen(r_s_result.data()));
			return true;
		}
		// see if we made it

		if(n >= 0) // glibc 2.1
			n_size = n + 1; // precisely what is needed
		else // glibc 2.0, msvc
			n_size *= 2;

		if(!Resize_To_N(r_s_result, n_size))
			return false;
		// realloc to try again
	}
}

#endif //__STL_UTILS_NO_WIDE_STRINGS

}

/*
 *								=== ~STL Utilities ===
 */
