#!/bin/sh

echo "==== Bloom Filter ===="
echo "{| border=\"2\" cellspacing=\"0\" cellpadding=\"5\""
echo "|-"
echo "! insert ||query"

for fn0 in ` seq 4`
do
#echo "|| ` ./bloom-test data/bloom.config_$fn0 data/bloom.items_$fn1 data/bloom.queries_$fn2` "
	echo  "|- " 
	echo  -n "|| " 
	./bloom-test data/bloom.config_$fn0 data/bloom.items_$fn0 data/bloom.queries_$fn0 | sed -e "s/ *\([0-9]*\)  *\([0-9]*\)/\1 || \2 /"
	echo
done

echo "|-"
echo "|}"
echo


echo "==== Counting Bloom Filter ===="
echo "{| border=\"2\" cellspacing=\"0\" cellpadding=\"5\""
echo "|-"
echo "! insert ||query ||remove ||requery"

for fn0 in ` seq 4`
do
	echo  "|-" 
	echo  -n "|| " 
	./cbf4-test data/cbf4.config_$fn0 data/cbf4.items_$fn0 data/cbf4.queries_$fn0 data/cbf4.remove_$fn0 | sed -e "s/ *\([0-9]*\)  *\([0-9]*\) *\([0-9]*\)  *\([0-9]*\)/\1 || \2 || \3 || \4/"

echo
done

echo "|-"
echo "|}"
echo

