// hash_function.c
// IJC-DU2, priklad 2, 21.4.2009
// Autor: Lukas Kekely, xkekel00
#include "htable.h"

#ifdef NH
uint32_t hash_function(uint32_t str, unsigned char htable_size)
{
    return (htable_size)?str>>(32-htable_size):0;
}
#endif

#ifdef H
#define MAGIC 0x9e3779b9
static uint32_t SEED=0xDEADBEAF;

#define hash(a,b,c)\
{\
    /*(1)*/ a-=b;\
    /*(2)*/ a=(a-c)^(c>>13); b-=c;\
    /*(3)*/ b=(b-a)^(a<< 8); c-=a;\
    /*(4)*/ c=(c-b)^(b>>13); a-=b;\
    /*(5)*/ a=(a-c)^(c>>12); b-=c;\
    /*(6)*/ b=(b-a)^(a<<16); c-=a;\
    /*(7)*/ c=(c-b)^(b>> 5); a-=b;\
    /*(8)*/ a=(a-c)^(c>> 3); b-=c;\
    /*(9)*/ b=(b-a)^(a<<10); c-=a;\
    /*(10)*/c=(c-b)^(b>>15);\
}

///hashovacia funkcia 32-bitovej suciastky
uint32_t hash_function(uint32_t str, unsigned char htable_size)
{
    uint32_t a,b,c;

    /// /////////////////////////////////////////////
    ///stage 0
    a=MAGIC+str; //inicializacia
    b=MAGIC;
    c=SEED;

    hash(a,b,c); //samotne hashovanie
    return c&((1<<htable_size)-1);
}
#endif
