#include <time.h>

#include "platform.h"
#include "test.h"

#define die(str) {                          \
   fprintf(stderr,"ERROR (%s:%d): %s\n",    \
       __FILE__, __LINE__, str);            \
   exit(EXIT_FAILURE);                      \
}

#ifdef STATIC_DATA
const extern size_t binfile_s1;
const extern size_t binfile_s2;
extern char binfile_1[];
extern char binfile_2[];
#endif

char * config;
size_t config_size;

uint32_t * data;
size_t data_size;

/// spustenie: ./bp  [vstupne IP] [TBM strom]
int test_main(int argc, char *argv[])
{
#ifdef STATIC_DATA
    data = (uint32_t*) binfile_1;
    data_size = binfile_s1 >> 2;

    config = binfile_2;
    config_size = binfile_s2;
#else
    if(argc != 3)
        die("Usage: ./bp [inputIP] [TBMTree]")
    FILE *input = fopen(argv[1],"rb");
    if(input == NULL)
		die("fopen(input)");
    fseek(input, 0, SEEK_END);
    data_size = ftell(input) >> 2;
    rewind(input);
    if((data = malloc(data_size << 2)) == NULL)
		die("malloc()");
    if(fread(data, 4, data_size, input) != data_size)
		die("fread()");
    fclose(input);

    input = fopen(argv[2], "r");
    if (input==NULL)
        die("load");
    fseek(input, 0, SEEK_END);
    config_size = ftell(input);
    config = (char*) malloc(config_size);
    fseek(input, 0, SEEK_SET);
    fread(config, 1, config_size, input);
    fclose(input);
#endif
	
    if(load(config, config_size))
		die("load()");

	open_output();

	timer_start();
	for(int i = 0; i < data_size; i++)
	{
		lookup(data+i);
		print_output(data[i]);
	}
	close_output();


#ifndef topo
#ifndef PRINT_OUTPUT
	timer_print();
  printf("\n");
#endif
#else
    print_topo();
#endif

    clean();
#ifndef STATIC_DATA
    free(data);
    free(config);
#endif
    return EXIT_SUCCESS;
}
