#include <stdio.h>
#include <stdlib.h>

#include "match.h"
#include "test.h"
#include "platform.h"

#ifdef STATIC_DATA
const extern size_t binfile_s1;
const extern size_t binfile_s2;
extern char binfile_1[];
extern char binfile_2[];
#endif 

// data to be copied from files to memory...
char * pattern;
char * automat;
// ... and their length
int pattern_length;
int automat_length;

/*
 * test_config loads configuration from text file
 * and initializes Bloom filter structure.
 */

void test_config() {

  parse_file(automat, automat_length);
}

/*
 * test_load() copies data from input files to allocated memory buffers.
 */
void test_load(int argc, char *argv[]) {

#ifdef STATIC_DATA
  automat = binfile_1;
  automat_length = binfile_s1;

  pattern = binfile_2;
  pattern_length = binfile_s2;
#else
  if(argc != 3) {
    fprintf(stderr, "Usage: %s automat_file data_file \n", argv[0]);
    exit(EXIT_FAILURE);
  }

  FILE *input = fopen(argv[1], "r");
  if (input==NULL) exit(4);
  fseek(input, 0, SEEK_END);
  automat_length = ftell(input);
  automat = (char*) malloc(automat_length + 1);
  fseek(input, 0, SEEK_SET);
  fread(automat, 1, automat_length, input);
  fclose(input);
  automat[automat_length] = 0;	// It's a hack for fmemopen

  input = fopen(argv[2], "r");
  if (input==NULL) exit(4);
  fseek(input, 0, SEEK_END);
  pattern_length = ftell(input);
  pattern = (char*) malloc(pattern_length+1);
  fseek(input, 0, SEEK_SET);
  fread(pattern, 1, pattern_length, input);
  fclose(input);

  pattern[pattern_length] = 0;	// It's a hack for fmemopen
#endif // STATIC_DATA

  open_output();
}

/*
 * test_run does the test.
 * Data are read from memory buffers.
 */
void test_run() {

  struct match_t match;
  timer_start();
 
  matchInit(&match);

  passing_automat(pattern, pattern_length, &match);

  print_output(match.n1);
  print_output(match.n2);
  print_output(match.nMatches);
  for(int i = 0; i < match.nMatches; i++)
  {
	  print_output(match.matches[i]);
	  print_output(match.states[i]);
  }

  matchFree(&match);

  timer_print();

  // printf("\nMatches: %i, Trasitions: %i\n", match.nMatches, match.nTrans);
}


/*
 * test_clear deallocates resources.
 */
void test_clear() {

#ifndef STATIC_DATA
  free(pattern);
  free(automat);
#endif

  //free_memory(); // already freed in algorithm
  close_output();

}

int test_main(int argc, char *argv[]) {

  // *** load input data
  test_load(argc, argv);

  // *** load automat
  test_config();

  // *** test
  test_run();

  // *** clean up
  test_clear();

  printf("\n");

  return 0;

}
