#include "BSP.h"

#define MARK_F 0x80000000
#define ID_F   0x7FFFFFFF

/// globalna premenna na uchovanie stromu
static BSP_tree t;
/// default route:
static uint32_t default_route=0; //NOT FOUND


/// funkcia na vycistenie dynamickej pamate modulu
void BSP_clean(void)
{
    BSP_free(t);    //vycisti strom
}

/// funkcia na nacitanie reprezentacie stromu z textoveho suboru
int BSP_load(char * config, size_t size)
{
    skipSpace(config);

    unsigned pom,count;
    if(!sscanf(config,"%u %u %hhu %u",&count,&pom,&(t.start),&default_route)) return 1;
    nextWord(config); nextWord(config); nextWord(config); nextWord(config);
    BSP_init(&t);  //inicializuje sa miesto pre strom
    if(t.ptr==NULL) return 1;
    for(register unsigned i=0; i<count; i++)
    {
        ///subor pokracuje uzlami
        // kazdy uzol == jeden riadok s LENGTH a POCTOM_PREFIXOV spolu s LCHILD a RCHILD
        //               POCET_PREFIXOVx riadok:
        //                                      [ID vysledku] [prefix] [mark]
        unsigned len,pom,lch,rch;
        if(sscanf(config,"%u %u %u %u",&len,&pom,&lch,&rch)!=4)
        {
            BSP_clean();
            return 1;
        }
        nextWord(config); nextWord(config); nextWord(config); nextWord(config);
        t.ptr[len].length=len;
        t.ptr[len].lchild=lch;
        t.ptr[len].rchild=rch;
        htable_init(&(t.ptr[len].ht),pom);
        for(register unsigned j=0; j<pom; j++)
        {
            uint32_t key,ID,mark;
            if(sscanf(config,"%u %u %u",&ID,&key,&mark)!=3)
            {
                BSP_clean();
                return 1;
            }
             nextWord(config); nextWord(config); nextWord(config);
            if(!htable_insert(&(t.ptr[len].ht),key,ID|((unsigned)mark<<31)))
            {
                BSP_clean();
                return 1;
            }
        }
    }
    return 0;
}


/// LPM vyhladavanie
//   x= ukazatel na strukturu s argumentami funkcie (vid main.h)
// POZN: rozhranie funkcie definovane tak aby sa dalo pouzit pri praci s pthreads
//void *BSP_lookup(void * data, unsigned int size)
void *BSP_lookup(uint32_t * IPi)
{
  //  uint32_t *IPi=(uint32_t*)data;          //iterator do pola vstupnych IP
    //while(IPi < ((uint32_t*)data) + size)
    {
        uint32_t IP=*IPi;                           //vyberiem IP odkazovanu iteratorom
        unsigned IP_piece;                          //sem sa bude vymaskovavat cast IP relevantna pre aktualne spracovavany TBM uzol
        uint32_t res=0;                             //ID vysledneho prefixu (LPM) POZN: 0 je ID pre nenajdenu zhodu
///!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
/// start algoritmu
        unsigned char act=t.start;                  //aktualny prvok je na zaciatku vybrany root uzol celeho stromu
        do                                          /// cyklus kym som v strome (naslednik != NULL)
        {
            IP_piece=IP&(0xFFFFFFFF<<(32-t.ptr[act].length));
            struct htable_listitem *match;
            if((match=htable_lookup(&(t.ptr[act].ht),IP_piece))!=NULL)
			{
			    res=match->data&ID_F;
			    if(match->data&MARK_F) act=t.ptr[act].rchild; //PRAVY syn
				else break;  //len prefix bez pokracovania
			}
			else act=t.ptr[act].lchild; //LAVY SYN
        } while(act!=0);
        if(!res) res=default_route; //ak nebolo nic najdene pouzijem defaultnu cestu
        *IPi=res;
/// koniec algoritmu
//        IPi++;          //posun na dalsiu IP
    }

    return NULL;
}
