// htable.h
// IJC-DU2, priklad 2, 21.4.2009
// Autor: Lukas Kekely, xkekel00
#ifndef MOD_HTABLE_H
#define MOD_HTABLE_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <stdint.h>

/// tabulka
struct htable_t
{
    struct htable_listitem **p;   //tabulka
    unsigned char size;           //velkost
};

/*
/// iterator do tabulky
struct htable_iterator
{
    struct htable_t *htptr;      //uk. tabulky
    int index;                   //index prvku
    struct htable_listitem *ptr; //uk. prvku
};
*/

/// prvok tabulky
struct htable_listitem
{
    uint32_t key;                  //IP prefix
    uint32_t data;                 //ID prefixu (MSB zneuzity na MARK, staci 2^31 prefixov a usetrim char naviac)
    struct htable_listitem *next;  //nasledovnik
};

uint32_t hash_function(uint32_t str, unsigned char htable_size);               //hashovacia funkcia
int htable_init(struct htable_t *t, unsigned real_size);                           //vytvorenie tabulky
struct htable_listitem *htable_lookup(struct htable_t *t, uint32_t key);      //najdenie prvku
int htable_insert(struct htable_t *t, uint32_t key, uint32_t data);      //vlozenie prvku
void htable_clear(struct htable_t *t);                                     //vycistenie tabulky
void htable_free(struct htable_t *t);                                      //zrusenie tabulky

/*
struct htable_iterator htable_begin(struct htable_t *t);                   //iterator na zaciatku
struct htable_iterator htable_end(struct htable_t *t);                     //iterator na koniec
struct htable_iterator htable_it_next(struct htable_iterator i);           //iterator dalsi prvok
inline bool htable_it_eq(struct htable_iterator it1, struct htable_iterator it2); //porovnanie iteratorov
inline struct htable_listitem *htable_it_deref(struct htable_iterator i);         //iterator --> ukazatel
*/

#endif
