/// Lukas Kekely, xkekel00@stud.fit.vutbr.cz
/// SST.h - hlavickovy subor modulu obsahujuceho Shape-Shifting Trie algoritmus

#ifndef MOD_SST_H
#define MOD_SST_H

#include <stdint.h>
#include <ctype.h>

#ifndef K
#define K 15
#endif

#define getbit(x,i) (((x)>>(i))&1)
#define skipSpace(cfg) { while(isspace(*cfg)) cfg++; }
#define nextWord(cfg)  { while(!isspace(*cfg)) cfg++; while(isspace(*cfg)) cfg++; }


/// nastavenie parametrov podla zvoleneho poctu uzlov v jednom SST uzle
#if K == 4
#    define uintx2_t uint8_t    // prvy typ bitmapy (SBM) ma 2 bity na uzol => K*2 bitov
#    define uintx1_t uint8_t    // druhy typ bitmapy (IBM resp EBM) ma 1 bit na kazdy uzol => K bitov (resp K+1 bitov)
#    define FORMAT_STRING "%u %u %hhu %hhu %hhu"
#elif K == 7
#    define uintx2_t uint16_t
#    define uintx1_t uint8_t
#    define FORMAT_STRING "%u %u %hu %hhu %hhu"
#elif K == 15
#    define uintx2_t uint32_t
#    define uintx1_t uint16_t
#    define FORMAT_STRING "%u %u %u %hu %hu"
#elif K == 31
#    define uintx2_t uint64_t
#    define uintx1_t uint32_t
#    define FORMAT_STRING "%u %u %lu %u %u"
#endif


/// struktura na ulozenie uzla SST stromu
typedef struct {
    uint32_t prefix_start;  //cislo prveho prefixu v tomto uzle
    uint32_t child_start;   //cislo prveho naslednika tohto uzla
    uintx2_t SBM;           //bitmapa reprezentujuca tvar podstromu v SST uzle, 2bity na jeden uzol
    uintx1_t EBM;           //externa bitmapa, reprezentuje pokracovania stromu z daneho SST uzla
    uintx1_t IBM;           //interna bitmapa, reprezentuje ukoncene prefixy v danom SST uzle
#ifdef topo
    uint32_t count;         //ak sa pracuje s pokrytim bude v kazdom uzle naviac pocitadlo navstev
#endif
} SST_node;
typedef SST_node *SST_tree; //strom je len ukazatal na root uzol


///konstruktor a destruktor stromu
#define SST_init(count) (SST_tree)malloc(sizeof(SST_node)*(count))
#define SST_free(tree) free(tree)


///funkcie rozhrania modulu
void SST_clean(void);        //vycistenie pamate celeho modulu
int SST_load(char * config, size_t size);             //nacitanie reprezentacie SST stromu zo suboru
//void *SST_lookup(void * data, unsigned int size);     //vyhladavanie v SST strome
void *SST_lookup(uint32_t * data);//void * data, unsigned int size);     //vyhladavanie v SST strome
void SST_print_topo();              //vypis topologie vstupneho suboru vzhladom na SST strom a prefixovu sadu

#endif
