////////////////////////////////////////////////////////////////////////////////////////////////////
//\file  D:\BioMarker\Software\Iterative\include\Constraint.h
//
//\brief Declares the constraint class. 
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef Constraint_H_included
#define Constraint_H_included


#include <MDSTk/Image/mdsImage.h>

////////////////////////////////////////////////////////////////////////////////////////////////////
//\class CConstraint
//
//\brief Constraint. 
////////////////////////////////////////////////////////////////////////////////////////////////////

class CConstraint
{
public:
   //! Pixel type
   typedef mds::img::tComplexPixel tPixel;

   //! Constructor
   CConstraint() : m_changed( 0 ) {}

   //! Constrain data
   virtual void operator () ( tPixel & pixel ) {}

   //! Get changed pixels value
   long getValue( ) { return m_changed; }

protected:
   //! Number of changed pixels
   long m_changed;
};

////////////////////////////////////////////////////////////////////////////////////////////////////
//\class CMinMax
//
//\brief Minimum and maximum. 
////////////////////////////////////////////////////////////////////////////////////////////////////

class CMinMax : public CConstraint
{
public:
   //! Constructor
   CMinMax( const tPixel min, const tPixel max ) : m_min( min ), m_max( max ) {}

   //! Constrain data
   virtual void operator () ( tPixel & pixel ) 
   {
      float re( pixel.re() ), im( pixel.im() );
     pixel.re() = mds::math::getMin< float >( mds::math::getMax< float >( pixel.re(), m_min.re() ), m_max.re() );
     //pixel.re() = mds::math::getMax< float >( pixel.re(), m_min.re() );
     pixel.im() = mds::math::getMin< float >( mds::math::getMax< float >( pixel.im(), m_min.im() ), m_max.im() );

      if( re != pixel.re() || im != pixel.im() )
         ++m_changed;
   }


protected:
   //! Minimal and maximal value. Each component is tested separately.
   tPixel m_min, m_max;
};

////////////////////////////////////////////////////////////////////////////////////////////////////
//\class COnlyReal
//
//\brief Only real part. 
////////////////////////////////////////////////////////////////////////////////////////////////////

class COnlyReal : public CConstraint
{
public:
   //! Constrain data
   virtual void operator () ( tPixel & pixel ) 
   { 
      if( pixel.im() != 0.0 )
         ++m_changed;

      pixel.im() = 0.0f; 
   }
 
};

// Constraint_H_included
#endif