////////////////////////////////////////////////////////////////////////////////////////////////////
//\file  D:\BioMarker\Software\Iterative\include\LamGoodman.h
//
//\brief Declares the lam goodman blind deconvolution filter.
//			Based on article: 
//			Iterative Blind Image Deconvolution in Space and Frequency Domains 
//			Authors:
//			Edmund Y. Lam, Joseph W. Goodman
//			Loc:
//			SPIE Vol: 3650 0277-786X/99
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef LamGoodman_H_included
#define LamGoodman_H_included

#include "ComplexFilter.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
//\class CLamGoodman
//
//\brief Lam goodman filter. 
////////////////////////////////////////////////////////////////////////////////////////////////////

class CLamGoodman : public CComplexFilter
{
public:
   //! Constructor
   CLamGoodman();

   //! Initializing constructor
   CLamGoodman( const tIImage & input, const tIImage & psf );

   //! Initialize - set input, set PSF 
   virtual bool init( const tIImage & input, const tIImage & psf );

   //! Initialize - use frequency domain data
   virtual bool initFD( const tImage & input, const tImage & psf );

   //! Do one iteration
   virtual void step();

   //! Filter 
   virtual int filter( mds::tSize max_steps );

   //! Test estimations
   bool testEstimations();

   //! Get filter output
   virtual void getOutput( tImage & image );

   //! Get filter output - frequency domain
   virtual void getOutputFD( tImage & image );

   //! Get noise image
   void getNoiseEstimation( tImage & image );

protected:
   //! Test psf estimation quality
   bool testPsfEstimation();

   //! Test image estimation quality
   bool testImageEstimation();

   //! Compute next image estimation
   void estimateImage();

   //! Compute next PSF estimation
   void estimatePSF();

   //! Estimate noise
   void estimateNoise();

   //! Create SNR estimation image
   void snr( );

   //! Noise estimation 2
   void snr2();

   void snr( const tImage & original, const tImage & estimate, tImage & noise );

protected:
   //! Working image
   tImagePtr m_wG;

   //! Working image - frequency domain
   tImagePtr m_wGfd;

   //! Estimated PSF
   tImagePtr m_wPSF;

   //! Estimated PSF - frequency domain
   tImagePtr m_wPSFfd;

   //! SNR estimation - image
   tImagePtr m_noiseImage;

   //! SNR estimation - psf
   tImagePtr m_noisePSF;

}; // class CLamGoodman

// LamGoodman_H_included
#endif

