////////////////////////////////////////////////////////////////////////////////////////////////////
//\file  D:\BioMarker\Software\Iterative\src\Region.cpp
//
//\brief Implements the region class. 
////////////////////////////////////////////////////////////////////////////////////////////////////

#include "Region.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
//\fn bool CRegion2D::getCommon(const CRegion2D &r1, const CRegion2D &r2, CRegion2D &result)
//
//\brief ! Compute common part of two regions. 
//
//\param r1                The first const CRegion2D &. 
//\param r2                The second const CRegion2D &. 
//\param [in,out] result   The result. 
//
//\return   true if it succeeds, false if it fails. 
////////////////////////////////////////////////////////////////////////////////////////////////////

bool CRegion2D::getCommon(const CRegion2D &r1, const CRegion2D &r2, CRegion2D &result)
{
   int x1, y1, x2, y2;
   int r1x2( r1.m_x + r1.m_w ), r1y2( r1.m_y + r1.m_h );
   int r2x2( r2.m_x + r2.m_w ), r2y2( r2.m_y + r2.m_h );

   x1 = r1.m_x > r2.m_x ? r1.m_x : r2.m_x;
   y1 = r1.m_x > r2.m_x ? r1.m_x : r2.m_x;
   x2 = r2x2 > r1x2 ? r1x2 : r2x2;
   y2 = r2y2 > r1y2 ? r1y2 : r2y2;

   if( y2 < y1 || x2 < x1 )
   	return(false);

   result.m_x = x1;
   result.m_y = y1;
   result.m_w = x2 - x1;
   result.m_h = y2 - y1;

   return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//\fn bool CRegion2D::isIn(const CRegion2D &r1, const CRegion2D &r2)
//
//\brief ! Is first region included in the second one? 
//
//\param r1 The first const CRegion2D &. 
//\param r2 The second const CRegion2D &. 
//
//\return   true if in, false if not. 
////////////////////////////////////////////////////////////////////////////////////////////////////

bool CRegion2D::isIn(const CRegion2D &r1, const CRegion2D &r2)
{
   int x1, y1, x2, y2;
   int r1x2( r1.m_x + r1.m_w ), r1y2( r1.m_y + r1.m_h );
   int r2x2( r2.m_x + r2.m_w ), r2y2( r2.m_y + r2.m_h );

   x1 = r1.m_x > r2.m_x ? r1.m_x : r2.m_x;
   y1 = r1.m_x > r2.m_x ? r1.m_x : r2.m_x;
   x2 = r2x2 > r1x2 ? r1x2 : r2x2;
   y2 = r2y2 > r1y2 ? r1y2 : r2y2;

   if( y2 < y1 || x2 < x1 )
   	return(false);
	
	return(true);
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//\fn CRegion2D & CRegion2D::=(const CRegion2D &region)
//
//\brief ! Assignment operator. 
//
//\param region   The region. 
//
//\return   . 
////////////////////////////////////////////////////////////////////////////////////////////////////

CRegion2D & CRegion2D::operator=(const CRegion2D &region)
{
   if( this == &region	)
      return *this;

   m_x = region.m_x;
   m_y = region.m_y;
   m_w = region.m_w;
   m_h = region.m_h;

   return *this;
}

