#include <cstdlib>
#include <iostream>

#include "../vtapi/include/vtapi_settings.h"
#include "../vtapi/include/vtapi.h"
#include "json/src/JSON.h"
#include "json/src/JSONValue.h"
#include "json/src/demo/functions.h"


// Print out function

void print_out(const wchar_t* output) {
    std::wcout << output;
    std::wcout.flush();
}

std::wstring StringToWString(const std::string& s) {
    std::wstring temp(s.length(), L' ');
    std::copy(s.begin(), s.end(), temp.begin());
    return temp;
}

std::wstring CharToWString(const char * s) {
    int len = strlen(s);
    wchar_t* buf = new wchar_t[ len ];
    size_t num_chars = mbstowcs(buf, s, len);
    std::wstring temp(buf, num_chars);
    return temp;
}

/**
 * The CLI main function
 * You can follow the
 *
 * @param argc
 * @param argv
 * @return sucess
 */
int main(int argc, char** argv) {
    VTApi * vtapi = new VTApi(argc, argv);
    Dataset* dataset = vtapi->newDataset();
    dataset->next();
    //vtapi->commons->
    
    JSONObject jsRoot;
    JSONObject jsSeq;


    
    Sequence* seq = dataset->newSequence(argv[1]);
    
    if (seq->next()) {
        jsSeq[L"name"] = new JSONValue(StringToWString(seq->getName().c_str()));
        JSONArray array;
       
        Image *img = seq->newImage();
        while (img->next()) {
            JSONObject picture;
            picture[L"path"]=new JSONValue(StringToWString(img->getDataLocation()));            
            array.push_back(new JSONValue(picture));
        }
        jsSeq[L"imgs"] = new JSONValue(array);
        jsRoot[L"sequence"]=new JSONValue(jsSeq);
    }else{
        jsRoot[L"sequence"]=new JSONValue(L"nodata");
    }

    // Create a value
    JSONValue *value = new JSONValue(jsRoot);
    print_out(value->Stringify().c_str());

    delete (dataset);
    delete (vtapi);
}


