#include <cstdlib>
#include <iostream>
#include <stdio.h>
#include <stdlib.h>

#include "../vtapi/include/vtapi_settings.h"
#include "../vtapi/include/vtapi.h"
#include "JSON.h"
#include "JSONValue.h"
#include <climits>


// Print out function

void print_out(const wchar_t* output) {
    std::wcout << output;
    std::wcout.flush();
}

std::wstring StringToWString(const std::string& s) {
    std::wstring temp(s.length(), L' ');
    std::copy(s.begin(), s.end(), temp.begin());
    return temp;
}

std::wstring IntToWString(const int i) {
    char buff[30];
    sprintf(buff,"%i",i);
    int len = strlen(buff);
    wchar_t* buf = new wchar_t[len];
    size_t num_chars = mbstowcs(buf, buff, len);
    std::wstring temp(buf, num_chars);
    return temp;
}

std::wstring CharToWString(const char * s) {
    int len = strlen(s);
    wchar_t* buf = new wchar_t[ len ];
    size_t num_chars = mbstowcs(buf, s, len);
    std::wstring temp(buf, num_chars);
    return temp;
}

/**
* Velmi velmi VELMI NEEFEKTIVNI zbytecne se prochazi vsechny sequence
**/
Sequence* isIdExist(const char * id,Dataset* dataset){
	Sequence* seq=dataset->newSequence();
	while(seq->next()){	
		//printf("%s\n",seq->getName().c_str());	
		if(strcmp(id,seq->getName().c_str())==0){
			return seq;
		}
	}	
	return NULL;
}

int getImageCount(Dataset * dataset, Sequence * seq){
	
  	KeyValues * kv = new KeyValues(*dataset);
  	kv->select = new Select(*kv, "SELECT MAX(t1) AS index FROM " + dataset->getDataset() + ".intervals WHERE seqname='"+ seq->getName() + "';");
  	// obtaining data
  	kv->next();
  	int count = kv->getInt("index");   

	

  return count;
}

/**
 *
 * @param argc
 * @param argv sequence img
 * @return sucess
 */
int main(int argc, char** argv) {
    fpos_t pos;
    fgetpos(stdout, &pos);
    int fd = dup(fileno(stdout));
    freopen ("get_tag_names.log","w",stdout);

	JSONObject jsRoot;
//	JSONObject *jsTags=new ;	
	JSONArray array;

	VTApi * vtapi = new VTApi(argc, argv);
	Dataset* dataset = vtapi->newDataset();
	printf("open dataset: %i\n", dataset->next());
	   
	KeyValues* tags = new KeyValues(*dataset, "tags");
	tags->select = new Select(*tags);
	tags->select->from("tags","real_name");
	tags->select->from("tags","tag_index");
	

	while (tags->next()){
		printf("tag:%i:%s\n",tags->getInt("tag_index"),tags->getString("real_name").c_str());	
//		JSONObject item;
//		item[IntToWString(tags->getInt("tag_index"))]=new JSONValue(StringToWString(tags->getString("real_name")));
		//array.push_back(new JSONValue(item));
		jsRoot[IntToWString(tags->getInt("tag_index"))]=new JSONValue(StringToWString(tags->getString("real_name")));
	}


	
   /* Sequence* seq = dataset->newSequence(argv[1]);
    
    if (seq->next()) {
	
        jsSeq[L"name"] = new JSONValue(StringToWString(seq->getName().c_str()));
        JSONArray array;
               
	Image *img=seq->newImage(argv[2]);
	if(img->next()){	
		cout<<img->getLocation()<<endl;
		string t=string("tags");
		int count;
		int *tags=img->getIntA(t,count);
		for(int i=0;i<count;i++){
			if(tags[i]!=0)
				array.push_back(new JSONValue(IntToWString(i*tags[i])));
		}

		jsImg[L"tags"]=new JSONValue(array);
		jsImg[L"name"]=new JSONValue(StringToWString(img->getLocation()));

		jsSeq[L"image"]=new JSONValue(jsImg);	
	
	}else{
		jsSeq[L"image"]=new JSONValue(L"nodata");	
	}
	
	jsRoot[L"sequence"]=new JSONValue(jsSeq);
    }else{
        jsRoot[L"sequence"]=new JSONValue(L"nodata");
    }*/

	
    delete (dataset);
    delete (vtapi);

	fflush(stdout);
	//Close file and restore standard output to stdout - which should be the terminal
	dup2(fd, fileno(stdout));
	close(fd);
	clearerr(stdout);
	fsetpos(stdout, &pos);

 // Create a value
    JSONValue *value = new JSONValue(jsRoot);
    print_out(value->Stringify().c_str());
}


