#include <cstdlib>
#include <iostream>

#include "../vtapi/include/vtapi_settings.h"
#include "../vtapi/include/vtapi.h"
#include "JSON.h"
#include "JSONValue.h"
#include <time.h>
#include <dirent.h> 




// Print out function

void print_out(const wchar_t* output) {
	std::wcout << output;
	std::wcout.flush();
}

std::wstring StringToWString(const std::string& s) {
	std::wstring temp(s.length(), L' ');
	std::copy(s.begin(), s.end(), temp.begin());
	return temp;
}

std::wstring CharToWString(const char * s) {
	int len = strlen(s);
	wchar_t* buf = new wchar_t[ len ];
	size_t num_chars = mbstowcs(buf, s, len);
	std::wstring temp(buf, num_chars);
	return temp;
}

/**
* Velmi velmi VELMI NEEFEKTIVNI zbytecne se prochazi vsechny sequence
**/
Sequence* isIdExist(const char * id,Dataset* dataset){
	Sequence* seq=dataset->newSequence();
	while(seq->next()){	
		//printf("%s\n",seq->getName().c_str());	
		if(strcmp(id,seq->getName().c_str())==0){
			return seq;
		}
	}	
	return NULL;
}

inline int signof(int a) { return (a == 0) ? 0 : (a<0 ? -1 : 1); }

unsigned char isFile =0x8;
/**
* param sequence_id photo_id tags...
*param tags - ie 20 31 -4 d6....
* return id sequence
**/
int main(int argc, char** argv)
{
	if(argc<=3){
		fprintf(stderr,"Params error!!\ni.e. update_tags seg_id photo_id tag1 -tag2 dtag3....\n");
		return -1;
	}

	/*fpos_t pos;
	fgetpos(stdout, &pos);
	int fd = dup(fileno(stdout));
	freopen ("upadate_tags.log","w",stdout);*/

	printf("open DB\n");
	VTApi * vtapi = new VTApi(1, argv);

	Dataset* dataset = vtapi->newDataset();
	if(dataset->next()){	
		Sequence* seq = dataset->newSequence(argv[1]);
		if(seq->next()){
			//add files from directory
			Image *img = seq->newImage(argv[2]);
			if(img->next()){
				int max_idx=-1;
				for(int i=3;i<argc;i++){				
					if(abs(atoi(argv[i]))>max_idx)max_idx=abs(atoi(argv[i]));
				}
				printf("max idx:%i\n",max_idx);

				string tags_label=string("tags");
				int count;
				int *tags=img->getIntA(tags_label,count);

				//V případě, že tag o tak velkem indexu se do pole nevejde je potřeba alokovat nove pole
				if(max_idx>=count){
					int * new_tags=new int[max_idx+1];
					memset(new_tags,0,sizeof(int)*(max_idx+1));
					memcpy(new_tags,tags,sizeof(int)*count);
					delete[] tags;
					tags=new_tags;
					count=max_idx+1;				
				}
				
				//Naplneni novýma hodnotama
				for(int i=3;i<argc;i++){
					int sig=0;
					int idx=0;
					if(argv[i][0]=='-'){
						sig=-1;
						idx=abs(atoi(argv[i]));
					}else if (argv[i][0]=='d'){
						sig=0;
						char * param=argv[i]+1;
						idx=abs(atoi(param));
					}else{
						sig=1;
						idx=atoi(argv[i]);
					}
					tags[idx]=sig;
				}
				
				img->setIntA(tags_label,tags,count);
				img->next();

				for(int i=0;i<count;i++){
					printf("%i,",tags[i]);
				}
				printf("\n%i\n",count);
			}else{
				printf("error open image\n");
			} 
		}else{
			printf("error open sequence\n");
		}
	}else{
		printf("error open dataset\n");
	}

	delete (dataset);
	delete (vtapi);

	/*fflush(stdout);
	//Close file and restore standard output to stdout - which should be the terminal
	dup2(fd, fileno(stdout));
	close(fd);
	clearerr(stdout);
	fsetpos(stdout, &pos);
*/
	
	return 0;
}
