from models import UserProfile, Gallery, Clan, ClanMembership, Permission, Photo, Tag
from django.contrib import admin

class UserProfileAdmin(admin.ModelAdmin):
    list_display = ('user', 'avatar')

class GalleryAdmin(admin.ModelAdmin):
    list_display = ('name', 'identificator', 'owner', 'cover_id')

class ClanAdmin(admin.ModelAdmin):
    list_display = ('name', 'owner', 'cover_id')

class ClanMembershipAdmin(admin.ModelAdmin):
    list_display = ('clan', 'user')

class PermissionAdmin(admin.ModelAdmin):
    list_display = ('gallery', 'clan', 'permission')

class PhotoAdmin(admin.ModelAdmin):
    list_display = ('name', 'path', 'gallery')

class TagAdmin(admin.ModelAdmin):
    list_display = ('name', 'description', 'identificator')


admin.site.register(UserProfile, UserProfileAdmin)
admin.site.register(Gallery, GalleryAdmin)
admin.site.register(Clan, ClanAdmin)
admin.site.register(ClanMembership, ClanMembershipAdmin)
admin.site.register(Permission, PermissionAdmin)
admin.site.register(Photo, PhotoAdmin)
admin.site.register(Tag, TagAdmin)
