from django.db import models
from django.contrib.auth.models import User
import base64
from django.conf import settings


class UserProfile(models.Model):
    user = models.OneToOneField(User)
    avatar = models.CharField(max_length=256)


class Gallery(models.Model):
	name = models.CharField(max_length=256)
	identificator = models.CharField(max_length=256)
	owner = models.ForeignKey(User)
	cover_id = models.CharField(max_length=256)

	def __unicode__(self):
		return self.name


class Clan(models.Model):
	name = models.CharField(max_length=256)
	owner = models.ForeignKey(User)
	cover_id = models.CharField(max_length=256)

	def __unicode__(self):
		return self.name


class ClanMembership(models.Model):
	clan = models.ForeignKey(Clan)
	user = models.ForeignKey(User)

	def __unicode__(self):
		return self.user.username + " in " + self.clan.name


class Permission(models.Model):
	gallery = models.ForeignKey(Gallery)
	clan = models.ForeignKey(Clan)
	permission = models.IntegerField()

	def __unicode__(self):
		return self.gallery.name + " for " + self.clan.name


class Photo(models.Model):
	name = models.TextField()
	path = models.CharField(max_length=600)
	gallery = models.ForeignKey(Gallery)	

	def __unicode__(self):
		return self.name

	
	def getId(self):
		tmp=self.path.split("/")
		filename=tmp[len(tmp)-1]
		return filename

	def getThumbPath(self,width):
		return settings.MEDIA_ROOT+"thumbs/"+width+"/"+base64.b16encode(self.path)

	def getThumbDir(self,width):
		return settings.MEDIA_ROOT+"thumbs/"+width+"/"
	



class Tag(models.Model):
	name = models.CharField(max_length=256)
	description = models.CharField(max_length=1024)
	identificator = models.CharField(max_length=256)

class TagMembership(models.Model):
	TAG_TYPE = (
        	(u'1', u'Positive'),
        	(u'-1', u'Negative'),
    	)
	tag= models.ForeignKey(Tag)
	photo = models.ForeignKey(Photo)
	tag_type=models.CharField(max_length=2, choices=TAG_TYPE)

class HistoryItem(models.Model):
	user = models.ForeignKey(User)
	timestamp = models.DateTimeField(auto_now=True)
	id_transaction= models.IntegerField()
	action = models.CharField(max_length=60)
	params = models.TextField()
