#Django imports
from django.shortcuts import render, render_to_response
from django.core.context_processors import csrf
from django.core.urlresolvers import reverse
from django.views.decorators.csrf import csrf_protect
from django.contrib.auth import authenticate, login, logout
from django.contrib.auth.models import User, AnonymousUser
from django.db import IntegrityError
from django.db.models import Max
from django.http import HttpResponse, HttpResponseRedirect
from django.conf import settings
from django import forms

#Projects imports
from debug import *
from permissions import *
from itsapp.models import *
import ITSconf
from itsapp.utils import *

#python imports
import os



#Funkce vraci JSON data pro zobrazeni side panelu
def get_data_left_side_panel(request):
	user=request.user
	if type(user)!=AnonymousUser:
		result =dict()

		user_section= dict()
		galleries=Gallery.objects.filter(owner=user)[0:3]
		for gallery in galleries:			
			user_section[gallery.identificator]={'name':gallery.name,'cover_id':gallery.cover_id}
		
		
		
		group_section= dict()
		groups=Clan.objects.filter(owner=user)[0:3]
		for group in groups:
			cover_id=None
			try:
				p=Photo.objects.get(id=group.cover_id)
				cover_id=p.id
				if(cover_id==-1):cover_id=get_unknow_avatar_id()
			except:
				cover_id=get_unknow_avatar_id()

			group_section[group.id]={'name':group.name,'cover_id':cover_id}

		result["group_section"]=group_section
		result["user_section"]=user_section
		profile=UserProfile.objects.get(user=user)
		result["user"]={'username':user.username,'avatar_id':profile.avatar}

		

		return render_json_data(request,result)
	return render_error(request,"Auth error")
		


	
    
    

