#!/bin/bash
REQUEST_PORT=7333
RESPONSE_PORT=7334

control_c()
# run if user hits control-c
{
  echo -en "\n*** Exiting ***\n"  
  kill $nc_pid
  exit $?
}
# trap keyboard interrupt (control-c)
trap control_c SIGINT SIGTERM SIGKILL SIGHUP

#cleanup
killall nc 2> /dev/null

#Run listening on port
echo "Start listening response on "`hostname`":"$RESPONSE_PORT
nc -k -l $RESPONSE_PORT > suggestion_responses &
nc_pid=$!
if [ $? -ne 0 ];then 
	echo "Create response port error!!"
	control_c
	exit
fi

#Run suggestion process on remote server
ssh kolarmartin@merlin.fit.vutbr.cz /mnt/matylda1/its/matlab_rbm_prediction/its_piped_predictor.sh $REQUEST_PORT $RESPONSE_PORT medusa.fit.vutbr.cz &
