/** @file config.cpp
* Nacteni konfigurace programu
* @author Radek Hranicky
*/

/*
LIS Noise Cleaner - Tento nastroj slouzi k filtraci sumu vytvoreneho programem LDP
Copyright (C) 2012 Radek Hranicky

Tento program je svobodny software: muzete jej sirit a upravovat podle ustanoveni Obecne verejne licence GNU (GNU General Public License),
vydavane Free Software Foundation a to bud podle 3. verze teto Licence, nebo (podle vaseho uvazeni) kterekoli pozdejsi verze.

Tento program je rozsirovan v nadeji, ze bude uzitecny, avas BEZ JAKEKOLIV ZARUKY. Neposkytuji se ani odvozene zaruky PRODEJNOSTI
anebo VHODNOSTI PRO URCITY UCEL. Dalsi podrobnosti hledejte v Obecne verejne licenci GNU.

Kopii Obecne verejne licence GNU jste meli obdrzet spolu s timto programem. Pokud se tak nestalo, najdete ji zde: <http://www.gnu.org/licenses/>.
*/

#include <iostream>
#include <fstream>
#include <sstream>
#include <list>
#include <regex.h>
#include <netinet/ip6.h>
#include <arpa/inet.h>

#include "config.h"
#include "errors.h"

/**
 * Inicializace konfigurace programu
 * @param konfigurace programu
 * @return chybovy kod
 */
void initConfig(TConfig &cfg) {
  cfg.input_file = "";
  cfg.output_file = "";
  cfg.pcapHandler = NULL;
  cfg.pcapDump = NULL;
  cfg.selected_packets.clear();
  cfg.pktCount = 0;
  cfg.tcpCount = 0;
  cfg.byteTcpCount = 0;
  cfg.pktWrittenCount = 0;
  return;
}

