/** @file packet.h
* hlavickovy soubor k packet.cpp
* @author Radek Hranicky
*/

/*
LIS Noise Cleaner - Tento nastroj slouzi k filtraci sumu vytvoreneho programem LDP
Copyright (C) 2012 Radek Hranicky

Tento program je svobodny software: muzete jej sirit a upravovat podle ustanoveni Obecne verejne licence GNU (GNU General Public License),
vydavane Free Software Foundation a to bud podle 3. verze teto Licence, nebo (podle vaseho uvazeni) kterekoli pozdejsi verze.

Tento program je rozsirovan v nadeji, ze bude uzitecny, avas BEZ JAKEKOLIV ZARUKY. Neposkytuji se ani odvozene zaruky PRODEJNOSTI
anebo VHODNOSTI PRO URCITY UCEL. Dalsi podrobnosti hledejte v Obecne verejne licenci GNU.

Kopii Obecne verejne licence GNU jste meli obdrzet spolu s timto programem. Pokud se tak nestalo, najdete ji zde: <http://www.gnu.org/licenses/>.
*/

#ifndef PACKET_H
#define PACKET_H

#define NEXT_HEADER_TCP 6
#define IPV6_FIXED_HEADER_LEN 40

#include "config.h"

int processPacket_phase1(pcap_pkthdr *pcap_header, u_char *packet, TConfig &cfg);
int processPacket_phase2(pcap_pkthdr *pcap_header, u_char *packet, TConfig &cfg);
TpacketInfo analyzePacket(pcap_pkthdr *pcap_header, u_char *packet);
bool comparePackets(TpacketInfo &pkt1, TpacketInfo &pkt2);
bool compareIp6Addr(in6_addr &addr1, in6_addr &addr2);

#endif
