----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------


-- retiming pls

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;
use IEEE.std_logic_unsigned.all;
use work.data_types.all;		-- my data types
use work.configure.all;		-- my data types

entity adress_engine is
	port(
		CLK	: in std_logic;
		
		ADDR_X	: in std_logic_vector(9 downto 0);
		ADDR_Y	: in std_logic_vector(9 downto 0);
		SCALE		: in std_logic_vector(3 downto 0);
		
		MEM_ADDR_A	: out array_12_9b;
		MEM_ADDR_B	: out array_12_9b;
		
		H_SHUFFLE	: out std_logic; 
		V_SHUFFLE	: out std_logic_vector(3 downto 0);
		C_SHUFFLE	: out std_logic_vector(2 downto 0);
		
		WRITE_SHUFFLE : out std_logic_vector(11 downto 0)
	);
end adress_engine;

architecture Behavioral of adress_engine is

	component div6 is
		Port ( 
		input 		: in   STD_LOGIC_VECTOR (10 downto 0);
      output 		: out  STD_LOGIC_VECTOR (7 downto 0)
		);
	end component;
	
	component mod6 is
		Port ( 
		input : in  STD_LOGIC_VECTOR (10 downto 0);
      output : out  STD_LOGIC_VECTOR (2 downto 0)
		);
	end component;
	
	component mod12 is
		Port ( 
		input : in  STD_LOGIC_VECTOR (10 downto 0);
      output : out  STD_LOGIC_VECTOR (3 downto 0));
	end component;

signal x			: std_logic_vector(10 downto 0);
signal x_div_2 : std_logic_vector(10 downto 0);
signal x_mod_6 : std_logic_vector(2 downto 0);
signal x_div_2_mod_6 : std_logic_vector(2 downto 0);
signal x_div_2_div_6 : std_logic_vector(7 downto 0);
signal x_addr_one_scale	: std_logic_vector(7 downto 0);
signal x_add	: std_logic;
signal x_addr	: std_logic_vector(7 downto 0);

signal y				: std_logic_vector(10 downto 0);
signal y_mod_12	: std_logic_vector(3 downto 0);
signal y_div_2		: std_logic_vector(10 downto 0);
signal y_div_12	: std_logic_vector(7 downto 0);
signal y_add		: std_logic_vector(11 downto 0);
signal y_write		: std_logic_vector(11 downto 0);

type array_12x8b is array (11 downto 0) of std_logic_vector(7 downto 0);
signal MEM_Y		: std_logic_vector(11 downto 0);
signal MEM_X_A, MEM_X_B : array_12x8b;

signal MEM_ADDR_A_befor	: array_12_9b;
signal MEM_ADDR_B_befor	: array_12_9b;
	
begin

	SYNC_PROC: process (CLK)
   begin
      if (CLK'event and CLK = '1') then
			H_SHUFFLE <= x_add;
			V_SHUFFLE <= y_mod_12;
			C_SHUFFLE <= x_mod_6;
			MEM_ADDR_A<= MEM_ADDR_A_befor;
			MEM_ADDR_B<= MEM_ADDR_B_befor;
			WRITE_SHUFFLE <= y_write;
		end if;
	end process; 
	
-----------------------------------------------

	x <='0'&ADDR_x;
	x_div_2 <= "00"&ADDR_X(9 downto 1);
	x_addr_one_scale <= x_div_2_div_6 + MEM_SCALE_ADR(conv_integer(SCALE));
	--x_addr_one_scale <= x_div_2_div_6;
	
	y <='0'&ADDR_Y;
	y_div_2 <= "00"&ADDR_Y(9 downto 1);
	
op_x_mod_6: mod6 port map(
		input  => x,
		output => x_mod_6
	);	
	
op_x_div_2_mod_6: mod6 port map(
		input  => x_div_2,
		output => x_div_2_mod_6
	);
	
op_x_div_2_div_6: div6 port map(
	input  => x_div_2,
	output => x_div_2_div_6
	);
	
op_y_mod_12: mod12 port map(
	input  => y,
	output => y_mod_12
	);
	
op_y_div_12: div6 port map(
	input  => y_div_2,
	output => y_div_12
);

-----------------------------------------------

WITH x_div_2_mod_6  SELECT	-- 6 z 1
    x_add <= 	'0' WHEN "000",
					'0' WHEN "001",
					'0' WHEN "010",
					'1' WHEN "011",
					'1' WHEN "100",
					'1' WHEN "101",
					'0' WHEN OTHERS;
					
WITH y_mod_12  SELECT	-- 12 z 1					
	y_add <= 	"000000000000" WHEN "0000",
					"000000000001" WHEN "0001",
					"000000000011" WHEN "0010",
					"000000000111" WHEN "0011",
					"000000001111" WHEN "0100",
					"000000011111" WHEN "0101",
					"000000111111" WHEN "0110",
					"000001111111" WHEN "0111",
					"000011111111" WHEN "1000",
					"000111111111" WHEN "1001",
					"001111111111" WHEN "1010",
					"011111111111" WHEN "1011",
					"000000000000" WHEN OTHERS;

WITH y_mod_12  SELECT	-- 12 z 1					
	y_write <= 	"000000000001" WHEN "0000",
					"000000000010" WHEN "0001",
					"000000000100" WHEN "0010",
					"000000001000" WHEN "0011",
					"000000010000" WHEN "0100",
					"000000100000" WHEN "0101",
					"000001000000" WHEN "0110",
					"000010000000" WHEN "0111",
					"000100000000" WHEN "1000",
					"001000000000" WHEN "1001",
					"010000000000" WHEN "1010",
					"100000000000" WHEN "1011",
					"000000000000" WHEN OTHERS;
-----------------------------------------------
	
gen: for N in 0 to 11 generate
		MEM_Y(N) 	<= y_div_12(0) xor y_add(N);
		MEM_X_A(N)  <= x_addr_one_scale WHEN x_add='0' ELSE x_addr_one_scale + 1;
		MEM_X_B(N)  <= x_addr_one_scale;
		
							-- outputs
		MEM_ADDR_A_befor(N)	<= MEM_Y(N)& MEM_X_A(N);
		MEM_ADDR_B_befor(N)	<= MEM_Y(N)& MEM_X_B(N);
	end generate;	
	
end Behavioral;

