----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
use work.configure.all;		-- my data types
use work.data_types.all;		-- my data types

entity compute_rank is
	port(
			CLK			: in std_logic;
			DATA_IN		: in dsp_out;
			POS			: in std_logic_vector(3 downto 0);
			
			RANK_BIT		: out std_logic_vector(8 downto 0)
		);
end compute_rank;

architecture Behavioral of compute_rank is
	
signal val 	: std_logic_vector(5 downto 0);
signal rank	: std_logic_vector(8 downto 0);
	
begin

SYN_PROC: process (DATA_IN,POS,CLK)
begin
	if( CLK'event and CLK = '1') then
		RANK_BIT <= rank;
	end if;
end process;
	
	
WITH POS  SELECT	-- 6 z 1
    val <=	DATA_IN(0) WHEN "0000",
				DATA_IN(1) WHEN "0001",
				DATA_IN(2) WHEN "0010",
				DATA_IN(3) WHEN "0011",
				DATA_IN(4) WHEN "0100",
				DATA_IN(5) WHEN "0101",
				DATA_IN(6) WHEN "0110",
				DATA_IN(7) WHEN "0111",
				DATA_IN(8) WHEN "1000",
				"000000"   WHEN OTHERS;

rank(0) <= '1' when val > DATA_IN(0) else '0';
rank(1) <= '1' when val > DATA_IN(1) else '0';
rank(2) <= '1' when val > DATA_IN(2) else '0';
rank(3) <= '1' when val > DATA_IN(3) else '0';
rank(4) <= '1' when val > DATA_IN(4) else '0';
rank(5) <= '1' when val > DATA_IN(5) else '0';
rank(6) <= '1' when val > DATA_IN(6) else '0';
rank(7) <= '1' when val > DATA_IN(7) else '0';
rank(8) <= '1' when val > DATA_IN(8) else '0';

end Behavioral;

