----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------

----------------------------------------------------------------------------------
-- Jedenáctibitová dělička šesti (vstup 0-1535)
--
-- Provedeme vydělení dvěma posuvem a poté tabulkové dělení třemi
--
-- Petr Musil
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VComponents.all;

entity div6 is
    Port ( 
		input 		: in   STD_LOGIC_VECTOR (10 downto 0);
      output 		: out  STD_LOGIC_VECTOR (7 downto 0)
		);
end div6;

architecture Behavioral of div6 is
	
	signal out0, out1, out2	: std_logic_vector ( 7 downto 0);

begin

ROM256X1_inst0 : ROM256X1
   generic map (
      INIT => X"8E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38")
   port map (
      O => out0(0),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );

ROM256X1_inst1 : ROM256X1
   generic map (
      INIT => X"0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0")
   port map (
      O => out0(1),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );
ROM256X1_inst2 : ROM256X1
   generic map (
      INIT => X"F000FFF000FFF000FFF000FFF000FFF000FFF000FFF000FFF000FFF000FFF000")
   port map (
      O => out0(2),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );
ROM256X1_inst3 : ROM256X1
   generic map (
      INIT => X"0000FFFFFF000000FFFFFF000000FFFFFF000000FFFFFF000000FFFFFF000000")
   port map (
      O => out0(3),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );
ROM256X1_inst4 : ROM256X1
   generic map (
      INIT => X"FFFF000000000000FFFFFFFFFFFF000000000000FFFFFFFFFFFF000000000000")
   port map (
      O => out0(4),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );
	
ROM256X1_inst5 : ROM256X1
   generic map (
		INIT => X"0000000000000000FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000")
   port map (
      O => out0(5),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );

ROM256X1_inst6 : ROM256X1
   generic map (
		INIT => X"FFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000")
   port map (
      O => out0(6),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );
	
ROM256X1_inst7 : ROM256X1
   generic map (
      INIT => X"38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E3")
   port map (
      O => out1(0),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );

ROM256X1_inst8 : ROM256X1
   generic map (
      INIT => X"C0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC")
   port map (
      O => out1(1),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );
ROM256X1_inst9 : ROM256X1
   generic map (
      INIT => X"00FFF000FFF000FFF000FFF000FFF000FFF000FFF000FFF000FFF000FFF000FF")
   port map (
      O => out1(2),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );
ROM256X1_inst10 : ROM256X1
   generic map (
      INIT => X"FF000000FFFFFF000000FFFFFF000000FFFFFF000000FFFFFF000000FFFFFF00")
   port map (
      O => out1(3),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );
ROM256X1_inst11 : ROM256X1
   generic map (
      INIT => X"00000000FFFFFFFFFFFF000000000000FFFFFFFFFFFF000000000000FFFFFFFF")
   port map (
      O => out1(4),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );
	
ROM256X1_inst12 : ROM256X1
   generic map (
		INIT => X"FFFFFFFF000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00000000")
   port map (
      O => out1(5),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );

ROM256X1_inst13 : ROM256X1
   generic map (
		INIT => X"00000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF")
   port map (
      O => out1(6),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );
	
	-------------
	
ROM256X1_inst14 : ROM256X1
   generic map (
      INIT => X"E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E38E")
   port map (
      O => out2(0),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );

ROM256X1_inst15 : ROM256X1
   generic map (
      INIT => X"FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0FC0F")
   port map (
      O => out2(1),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );
ROM256X1_inst16 : ROM256X1
   generic map (
      INIT => X"FFF000FFF000FFF000FFF000FFF000FFF000FFF000FFF000FFF000FFF000FFF0")
   port map (
      O => out2(2),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );
ROM256X1_inst17 : ROM256X1
   generic map (
      INIT => X"FFFFFF000000FFFFFF000000FFFFFF000000FFFFFF000000FFFFFF000000FFFF")
   port map (
      O => out2(3),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );
ROM256X1_inst18 : ROM256X1
   generic map (
      INIT => X"FFFFFFFFFFFF000000000000FFFFFFFFFFFF000000000000FFFFFFFFFFFF0000")
   port map (
      O => out2(4),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );
	
ROM256X1_inst19 : ROM256X1
   generic map (
		INIT => X"FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000FFFFFFFFFFFFFFFF")
   port map (
      O => out2(5),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );

ROM256X1_inst20 : ROM256X1
   generic map (
		INIT => X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000")
   port map (
      O => out2(6),   -- ROM output
      A0 => input(1), -- ROM address[0]
      A1 => input(2), -- ROM address[1]
      A2 => input(3), -- ROM address[2]
      A3 => input(4), -- ROM address[3]
      A4 => input(5), -- ROM address[4]
      A5 => input(6), -- ROM address[5]
      A6 => input(7),  -- ROM address[6]
      A7 => input(8)  -- ROM address[7]
   );
	
out0(7) <= '0';	
out1(7) <= not out1(6);
out2(7) <= '1';


mux: process(input, out0, out1, out2)
begin
	case input(10 downto 9) is
		when "00" =>   output <= out0;
		when "01" =>   output <= out1;
		when "10" =>   output <= out2;
		when "11" =>   output <= out0;
		when others => output <= out0;
	end case;
end process;
	
end Behavioral;

