----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.std_logic_unsigned.all;
use work.configure.all;		-- my data types
use work.data_types.all;		-- my data types

entity lrp is
	port(
		CLK 		: in std_logic;
		RANK_POS_A	: in std_logic_vector(3 downto 0); -- pozice RankA (0-8)
		RANK_POS_B	: in std_logic_vector(3 downto 0);
		
		DATA_IN	: in dsp_out;
		
		DATA_OUT	: out std_logic_vector(6 downto 0)
	);
end lrp;

architecture Behavioral of lrp is

	component compute_rank is
		port(
			CLK			: in std_logic;
			DATA_IN		: in dsp_out;
			POS			: in std_logic_vector(3 downto 0);
			
			RANK_BIT		: out std_logic_vector(8 downto 0)
		);
	end component;
	
	signal RANK_A_BIT : std_logic_vector(8 downto 0);
	signal RANK_B_BIT : std_logic_vector(8 downto 0);

begin
	-- vypočet RANK_A_BIT
	compute_RANK_A : compute_rank
		port map(
			CLK => CLK,
			DATA_IN => DATA_IN,
			POS => RANK_POS_A,
			RANK_BIT => RANK_A_BIT
		);
	-- vypočet RANK_B_BIT	
	compute_RANK_B : compute_rank
		port map(
			CLK => CLK,
			DATA_IN => DATA_IN,
			POS => RANK_POS_B,
			RANK_BIT => RANK_B_BIT
		);
		
	-- vypočteme hodnotu příznaku
	extract: process(CLK, RANK_A_BIT, RANK_B_BIT)
		variable temp1 : std_logic_vector(1 downto 0);
		variable temp2 : std_logic_vector(1 downto 0);
		variable temp3 : std_logic_vector(1 downto 0);
		variable temp4 : std_logic_vector(1 downto 0);
		variable temp5 : std_logic_vector(1 downto 0);
		variable temp6 : std_logic_vector(1 downto 0);
		variable RANK_A : std_logic_vector(3 downto 0);
		variable RANK_B : std_logic_vector(3 downto 0);
		
	begin
		if( CLK'event and CLK = '1') then
			-- musel jsem to vyjmout z funkce por počítaní ranku, aby stíhala pipeline
			temp1 := "00" + RANK_A_BIT(0 downto 0) + RANK_A_BIT(1 downto 1)+ RANK_A_BIT(2 downto 2); -- 2 bit adder
			temp2 := "00" + RANK_A_BIT(3 downto 3) + RANK_A_BIT(4 downto 4) + RANK_A_BIT(5 downto 5);-- 2 bit adder
			temp3 := "00" + RANK_A_BIT(6 downto 6) + RANK_A_BIT(7 downto 7) + RANK_A_BIT(8 downto 8);-- 2 bit adder
 			RANK_A := "0000" + temp1(1 downto 0) + temp2(1 downto 0) + temp3(1 downto 0); -- 4 bit adder

			temp4 := "00" + RANK_B_BIT(0 downto 0) + RANK_B_BIT(1 downto 1) + RANK_B_BIT(2 downto 2); -- 2 bit adder
			temp5 := "00" + RANK_B_BIT(3 downto 3) + RANK_B_BIT(4 downto 4) + RANK_B_BIT(5 downto 5);-- 2 bit adder
			temp6 := "00" + RANK_B_BIT(6 downto 6) + RANK_B_BIT(7 downto 7) + RANK_B_BIT(8 downto 8);-- 2 bit adder
 			RANK_B := "0000" + temp4(1 downto 0) + temp5(1 downto 0) + temp6(1 downto 0); -- 4 bit adder	
		
			DATA_OUT <=  RANK_B&"000" + RANK_B + RANK_A; -- 9 * RANK_B  + RANK_A  = 8 * RANK_B + RANK_B  + RANK_A
																-- normalizace na (0-80)																
		end if;
	end process;


end Behavioral;

